<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SpecialNumberReservation extends Model 
{

    protected $table = 'special_number_reservations';
    public $timestamps = true;
    protected $fillable = array('id', 'user_id', 'special_number_id', 'name_ar', 'name_en', 'address_ar', 'address_en', 'phone', 'status');

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function special_number()
    {
        return $this->belongsTo('App\Models\SpecialNumber');
    }

    public function files()
    {
        return $this->morphMany('App\Models\File', 'filable');
    }

}